<?php
session_start();
include "conexao.php";

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$usuario = $_SESSION['usuario'];
$isAdmin = $usuario['perfil'] === 'admin';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $empresa_id = $isAdmin ? $_POST['id_empresa'] : $usuario['id_empresa'];
    $senha_hash = password_hash($_POST['senha'], PASSWORD_DEFAULT);

    $stmt = $pdo->prepare("INSERT INTO funcionarios (id_empresa, nome, cpf, pis, cargo, tipo_jornada, senha)
                           VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $empresa_id, $_POST['nome'], $_POST['cpf'], $_POST['pis'],
        $_POST['cargo'], $_POST['tipo_jornada'], $senha_hash
    ]);
    echo "<p>Funcionário cadastrado com sucesso!</p>";
}

$empresas = [];
if ($isAdmin) {
    $empresas = $pdo->query("SELECT * FROM empresas ORDER BY razao_social")->fetchAll();
}
?>
<h2>Cadastro de Funcionário</h2>
<form method="post">
    <?php if ($isAdmin): ?>
        Empresa:
        <select name="id_empresa" required>
            <?php foreach ($empresas as $e): ?>
                <option value="<?php echo $e['id']; ?>"><?php echo $e['razao_social']; ?></option>
            <?php endforeach; ?>
        </select><br>
    <?php endif; ?>
    Nome: <input name="nome" required><br>
    CPF: <input name="cpf" required><br>
    PIS: <input name="pis" required><br>
    Cargo: <input name="cargo" required><br>
    Jornada: 
    <select name="tipo_jornada">
        <option value="8h">8h</option>
        <option value="12x36">12x36</option>
    </select><br>
    Senha: <input type="password" name="senha" required><br>
    <button type="submit">Cadastrar</button>
</form>
<p><a href="painel.php">Voltar</a></p>
