<?php
session_start();
include "conexao.php";

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$usuario = $_SESSION['usuario'];
$id_empresa = $usuario['perfil'] === 'admin' ? ($_POST['empresa_id'] ?? null) : $usuario['id_empresa'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['arquivo'])) {
    $linhas = file($_FILES['arquivo']['tmp_name']);
    $importados = 0;

    foreach ($linhas as $linha) {
        $data = substr($linha, 10, 8);
        $hora = substr($linha, 18, 4);
        $pis = substr($linha, 23, 12);

        $data_formatada = substr($data, 0, 2) . "-" . substr($data, 2, 2) . "-" . substr($data, 4, 4);
        $hora_formatada = substr($hora, 0, 2) . ":" . substr($hora, 2, 2) . ":00";
        $data_hora = "$data_formatada $hora_formatada";

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM batidas_afd WHERE pis = ? AND data_hora = ?");
        $stmt->execute([$pis, $data_hora]);
        if ($stmt->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO batidas_afd (pis, data_hora, tipo) VALUES (?, ?, 'AFD')");
            $stmt->execute([$pis, $data_hora]);
            $importados++;
        }
    }

    echo "<p>$importados batidas importadas com sucesso.</p>";
}

$empresas = [];
if ($usuario['perfil'] === 'admin') {
    $empresas = $pdo->query("SELECT * FROM empresas ORDER BY razao_social")->fetchAll();
}
?>
<h2>Importar Arquivo AFD</h2>
<form method="post" enctype="multipart/form-data">
    <?php if ($usuario['perfil'] === 'admin'): ?>
        Empresa:
        <select name="empresa_id" required>
            <?php foreach ($empresas as $e): ?>
                <option value="<?php echo $e['id']; ?>"><?php echo $e['razao_social']; ?></option>
            <?php endforeach; ?>
        </select><br>
    <?php endif; ?>
    Arquivo AFD: <input type="file" name="arquivo" required><br>
    <button type="submit">Importar</button>
</form>
<p><a href="painel.php">Voltar</a></p>
