<?php
session_start();
include "conexao.php";

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$usuario = $_SESSION['usuario'];
$mes = $_GET['mes'] ?? date('Y-m');
$id_empresa = $usuario['perfil'] === 'admin' ? ($_GET['empresa'] ?? null) : $usuario['id_empresa'];

$stmt = $pdo->prepare("SELECT * FROM funcionarios WHERE id_empresa = ?");
$stmt->execute([$id_empresa]);
$funcionarios = $stmt->fetchAll();

function formatBatidas($batidas) {
    $dias = [];
    foreach ($batidas as $b) {
        $dia = date('Y-m-d', strtotime($b['data_hora']));
        $dias[$dia][] = $b;
    }
    return $dias;
}
?>
<h2>Espelho de Ponto - <?php echo $mes; ?></h2>
<?php foreach ($funcionarios as $f): ?>
    <h3><?php echo $f['nome']; ?> (<?php echo $f['cpf']; ?>)</h3>
    <?php
        $stmt1 = $pdo->prepare("SELECT * FROM batidas_afd WHERE pis = ? AND DATE_FORMAT(data_hora, '%Y-%m') = ?");
        $stmt1->execute([$f['pis'], $mes]);
        $afd = $stmt1->fetchAll();

        $stmt2 = $pdo->prepare("SELECT * FROM batidas_online WHERE id_funcionario = ? AND DATE_FORMAT(data_hora, '%Y-%m') = ?");
        $stmt2->execute([$f['id'], $mes]);
        $online = $stmt2->fetchAll();

        $batidas = array_merge($afd, $online);
        $dias = formatBatidas($batidas);
    ?>
    <?php foreach ($dias as $dia => $registros): ?>
        <b><?php echo $dia; ?></b><br>
        <ul>
        <?php foreach ($registros as $r): ?>
            <li><?php echo date('H:i:s', strtotime($r['data_hora'])) . " - " . ($r['tipo'] ?? 'AFD'); ?></li>
        <?php endforeach; ?>
        </ul>
    <?php endforeach; ?>
<?php endforeach; ?>
<p><a href="painel.php">Voltar</a></p>
